var editButton = document.createElement('button');
editButton.innerHTML = 'Edit level data';
Module.canvas.insertAdjacentElement('afterend', editButton);

let logList = [];
let updateLogView = function () { };
Module.LogMessage = function (logLevel, message) {
    logList.push([logLevel, message]);
    if (console && console.log)
        console.log("LogMessage: ", message);
    updateLogView();
}

editButton.onclick = function () {
    editButton.style.display = 'none';
    let container = document.createElement('div');
    container.innerHTML = `
<div style='border: 1px solid #000; margin:10px; box-shadow:0 3px 10px #0004'>
<div style='display: flex; align-items: flex-start; height: 400px;'>
    <div class='line-numbers' style='padding: 10px 0px; overflow-y: auto; height: 380px;
     scrollbar-width: none; -ms-overflow-style: none; white-space: pre;
        background:rgb(44, 45, 48); color:#888; text-align: right; user-select: none; font-family: monospace;'></div>
    <textarea class='textarea' rows='20' cols='80' spellcheck='false' style='
        width: 100%; height: 380px; padding: 10px; margin:0; border: none; outline: none; resize: none; 
        overflow-y: auto; font-family: monospace;'></textarea>
    <div style='width: 100px; background:#353030; height:390px; padding:5px'>
        <button style='width:100%'>Load data</button>
    </div>
</div>
<div class='logs' style='height: 100px; overflow-y: auto; background:#333330; color:#ddd; padding: 10px;
  font-family:monospace; border-top:1px solid #000'></div>
</div>
`
    Module.canvas.insertAdjacentElement('afterend', container);


    const codeArea = container.querySelector('.textarea');
    const lineNumbers = container.querySelector('.line-numbers');
    const loadButton = container.querySelector('button');
    const logs = container.querySelector('.logs');
    updateLogView = function () {
        logs.innerHTML = logList.map(([logLevel, message]) => {
            return `<div style="color: ${logLevel > 3 ? '#c60' : '#bbb'}">${message}</div>`;
        }).join('');
        logs.scrollTop = logs.scrollHeight;
        errorLines = {};
        for (var i = logList.length - 1; i >= 0; i--) {
            var [logLevel, message] = logList[i];
            if (logLevel > 3) {
                var match = message.match(/line (\d+):/);
                if (match) {
                    errorLines[parseInt(match[1])] = message;
                    break
                }
            }
            break
        }
        updateLineNumbers();
    }
    updateLogView();
    var errorLines = {};
    function updateLineNumbers() {
        const lines = codeArea.value.split('\n').length;
        lineNumbers.innerHTML = Array.from({ length: lines },
            (_, i) => {
                let error = errorLines[i + 1];
                let num = (i + 1) + ' ';
                if (num < 10) num = ' ' + num;
                if (num < 100) num = ' ' + num;
                if (error) {
                    return `<div style="background:#833;color:#ec8;text-align:right" title="${error}">  ${num}  </div>`;
                }
                return `<div style="text-align:right">  ${num}  </div>`;
            }
        ).join('');
    }
    function syncScroll() {
        lineNumbers.scrollTop = codeArea.scrollTop;
    }

    codeArea.addEventListener('input', updateLineNumbers);
    codeArea.addEventListener('scroll', syncScroll);
    lineNumbers.addEventListener('scroll', syncScroll);

    loadButton.onclick = function () {
        var levelData = codeArea.value;
        FS.writeFile('data/level.txt', levelData);
        Module._RequestReload();
    }

    codeArea.value = FS.readFile('data/level.txt', { encoding: 'utf8' });

    updateLineNumbers();

    // Function to highlight lines with errors
    function highlightErrorLines(lines) {
        const codeLines = codeArea.value.split('\n');
        const highlightedCode = codeLines.map((line, index) => {
            return lines.includes(index + 1) ? `<span class="highlight">${line}</span>` : line;
        }).join('\n');
        codeArea.innerHTML = highlightedCode;
    }

    // Example usage: Highlight lines 2 and 4
    // highlightErrorLines([2, 4]);

}